/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.multilingual.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.formgenerator.service.EnhanceFormFieldService;
import com.elitesland.cbpl.formgenerator.vo.resp.FormHistoryVO;
import com.elitesland.cbpl.multilingual.db.constant.LangCondition;
import com.elitesland.cbpl.multilingual.spi.MultilingualSpi;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.StringTemplate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultilingualCommon {
    private static final Logger logger = LoggerFactory.getLogger(MultilingualCommon.class);

    protected static String obtainLanguage() {
        if (SpringUtils.isPresent(MultilingualSpi.class)) {
            MultilingualSpi multilingualService = (MultilingualSpi)SpringUtils.getBean(MultilingualSpi.class);
            return multilingualService.obtainLanguage();
        }
        logger.warn("[Multilingual] obtainLanguage failed.");
        return null;
    }

    protected static boolean translateRequired(Class<?> tableClass, String tableField) {
        String className = tableClass.getName();
        EnhanceFormFieldService fieldService = (EnhanceFormFieldService)SpringUtils.getBean(EnhanceFormFieldService.class);
        FormHistoryVO formVO = fieldService.queryEffectiveByTableClass(className);
        List fields = fieldService.queryFieldsByFormCode(formVO.getFormCode(), formVO.getVersion());
        return fields.stream().anyMatch(field -> field.getFieldCode().equals(tableField));
    }

    protected static String translateField(String tableField) {
        if (StrUtil.isEmpty((CharSequence)MultilingualCommon.obtainLanguage())) {
            return "$." + CharSequenceUtil.toUnderlineCase((CharSequence)tableField);
        }
        return "$." + MultilingualCommon.obtainLanguage() + "." + CharSequenceUtil.toUnderlineCase((CharSequence)tableField);
    }

    protected static Predicate builder(StringPath field, String value, int condition) {
        PathMetadata metadata = field.getMetadata();
        Path rootPath = metadata.getRootPath();
        Class clazz = rootPath.getType();
        if (MultilingualCommon.translateRequired(clazz, metadata.getName())) {
            PathBuilder entityPath = new PathBuilder(clazz, StrUtil.lowerFirst((CharSequence)clazz.getSimpleName()));
            StringPath path = entityPath.getString("languageTranslation");
            StringTemplate expr = Expressions.stringTemplate((String)"json_unquote(json_extract({0}, {1}))", (Object[])new Object[]{path, MultilingualCommon.translateField(metadata.getName())});
            if (condition == LangCondition.EQUALS.getCode()) {
                return field.eq((Object)value).or((Predicate)expr.eq((Object)value));
            }
            if (condition == LangCondition.LIKE.getCode()) {
                String likeStr = SqlUtil.toSqlLikeString((String)value);
                return field.like(likeStr).or((Predicate)expr.like(likeStr));
            }
        }
        if (condition == LangCondition.EQUALS.getCode()) {
            return field.eq((Object)value);
        }
        if (condition == LangCondition.LIKE.getCode()) {
            String likeStr = SqlUtil.toSqlLikeString((String)value);
            return field.like(likeStr);
        }
        return null;
    }
}

