package com.elitesland.cbpl.multilingual.cache;

import com.elitesland.cbpl.formgenerator.service.EnhanceFormFieldService;
import com.elitesland.cbpl.formgenerator.vo.resp.HistoryFieldVO;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/12/03
 */
public class MultilingualCache {

    /**
     * 从缓存中，读取数据库表，需要翻译的字段
     */
    public static List<HistoryFieldVO> languageFields(Class<?> tableClass) {
        // TODO 从缓存中过滤，使用三级缓存
        String className = tableClass.getName();
        var fieldService = SpringUtils.getBean(EnhanceFormFieldService.class);
        var formVO = fieldService.queryEffectiveByTableClass(className);
        return fieldService.queryFieldsByFormCode(formVO.getFormCode(), formVO.getVersion());
    }
}
