/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.multilingual.repo;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import com.elitesland.cbpl.formgenerator.vo.resp.HistoryFieldVO;
import com.elitesland.cbpl.multilingual.common.util.MultilingualUtil;
import com.elitesland.cbpl.multilingual.domain.MultilingualFieldVO;
import com.elitesland.cbpl.multilingual.domain.MultilingualVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class MultilingualRepoProc {
    private final JPAQueryFactory jpaQueryFactory;

    public Map<String, String> query(Class<?> tableClass, Long bizKey, List<HistoryFieldVO> fields) {
        PathBuilder<?> entity = MultilingualUtil.pathBuilder(tableClass);
        Object[] paths = new StringPath[]{};
        paths = (StringPath[])ArrayUtil.append((Object[])paths, (Object[])new StringPath[]{entity.getString("languageTranslation")});
        for (HistoryFieldVO field : fields) {
            paths = (StringPath[])ArrayUtil.append((Object[])paths, (Object[])new StringPath[]{entity.getString(field.getFieldCode())});
        }
        NumberPath id = entity.getNumber("id", Long.class);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression[])paths).from(entity)).where((Predicate)id.eq((Object)bizKey));
        Tuple tuple = (Tuple)jpaQuery.fetchOne();
        if (tuple == null) {
            throw PhoenixException.unexpected((String)("\u6570\u636e(" + bizKey + ")\u4e0d\u5b58\u5728"));
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Object path : paths) {
            result.put(path.getMetadata().getName(), (String)tuple.get((Expression)path));
        }
        return result;
    }

    public long update(Class<?> tableClass, MultilingualVO multilingualVO) {
        PathBuilder<?> entity = MultilingualUtil.pathBuilder(tableClass);
        JPAUpdateClause update = this.jpaQueryFactory.update(entity);
        Map<String, List<String>> params = this.updateParamBuilder(multilingualVO);
        StringPath languageTranslation = entity.getString("languageTranslation");
        MultilingualUtil.updateClause(update, languageTranslation, params);
        NumberPath id = entity.getNumber("id", Long.class);
        update.where(new Predicate[]{id.eq((Object)multilingualVO.getBizKey())});
        return update.execute();
    }

    private Map<String, List<String>> updateParamBuilder(MultilingualVO multilingualVO) {
        HashMap<String, List<String>> fieldParams = new HashMap<String, List<String>>();
        for (MultilingualFieldVO field : multilingualVO.getFields()) {
            for (Map.Entry<String, String> entry : field.getTranslate().entrySet()) {
                ArrayList<String> fieldValues = (ArrayList<String>)fieldParams.get(entry.getKey());
                if (fieldValues == null) {
                    fieldValues = new ArrayList<String>();
                }
                fieldValues.add(CharSequenceUtil.toUnderlineCase((CharSequence)field.getFieldCode()));
                fieldValues.add(entry.getValue());
                fieldParams.put(entry.getKey(), fieldValues);
            }
        }
        return fieldParams;
    }

    public MultilingualRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

