package com.elitesland.cbpl.multilingual.controller;

import cn.hutool.core.lang.Assert;
import com.elitesland.cbpl.multilingual.domain.MultilingualVO;
import com.elitesland.cbpl.multilingual.service.MultilingualService;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * @author eric.hao
 * @since 2024/12/02
 */
@Slf4j
@Api(tags = "多语言翻译工具")
@RestController
@RequestMapping("/multilingual")
@RequiredArgsConstructor
public class MultilingualController {

    private final MultilingualService multilingualService;

    @ApiOperation(value = "01.单条数据-多语言翻译")
    @GetMapping(value = "/queryTranslate")
    public HttpResult<MultilingualVO> queryTranslate(String formCode, Long bizKey) {
        Assert.notBlank(formCode, "表单编码(formCode)必填");
        Assert.notNull(bizKey, "业务主键(bizKey)必填");
        logger.info("[Multilingual] query business data: {}, {}", formCode, bizKey);
        return HttpResult.ok(multilingualService.queryTranslate(formCode, bizKey));
    }

    @ApiOperation(value = "02.单条数据-更新翻译内容")
    @PutMapping(value = "/updateTranslate")
    public HttpResult<Boolean> updateTranslate(@RequestBody @Valid MultilingualVO multilingualVO) {
        logger.info("[Multilingual] update business translate: {}", multilingualVO);
        return HttpResult.ok(multilingualService.updateTranslate(multilingualVO));
    }
}
