package com.elitesland.cbpl.multilingual.service;

import com.elitesland.cbpl.multilingual.domain.MultilingualVO;

import javax.validation.Valid;

/**
 * @author eric.hao
 * @since 2024/12/02
 */
public interface MultilingualService {

    /**
     * 查询翻译内容
     *
     * @param formCode 表单编码
     * @param bizKey   业务主键
     * @return 翻译内容
     */
    MultilingualVO queryTranslate(String formCode, Long bizKey);

    /**
     * 更新翻译内容
     *
     * @param multilingualVO 更新参数
     * @return 是否更新成功
     */
    Boolean updateTranslate(@Valid MultilingualVO multilingualVO);
}
