/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.multilingual.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.cbpl.formgenerator.entity.EnhanceFormDO;
import com.elitesland.cbpl.formgenerator.repo.EnhanceFormRepoProc;
import com.elitesland.cbpl.formgenerator.vo.resp.HistoryFieldVO;
import com.elitesland.cbpl.multilingual.cache.MultilingualCache;
import com.elitesland.cbpl.multilingual.domain.MultilingualFieldVO;
import com.elitesland.cbpl.multilingual.domain.MultilingualVO;
import com.elitesland.cbpl.multilingual.repo.MultilingualRepoProc;
import com.elitesland.cbpl.multilingual.service.MultilingualService;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MultilingualServiceImpl
implements MultilingualService {
    private static final Logger logger = LoggerFactory.getLogger(MultilingualServiceImpl.class);
    private final MultilingualRepoProc multilingualRepoProc;
    private final EnhanceFormRepoProc enhanceFormRepoProc;

    @Override
    public MultilingualVO queryTranslate(String formCode, Long bizKey) {
        List<HistoryFieldVO> fields;
        MultilingualVO multilingualVO = new MultilingualVO();
        multilingualVO.setFormCode(formCode);
        multilingualVO.setBizKey(bizKey);
        EnhanceFormDO formDO = this.enhanceFormRepoProc.findByFormCode(formCode);
        if (formDO == null) {
            throw new IllegalArgumentException("\u8868\u5355(" + formCode + ")\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528");
        }
        Class<?> tableClass = Class.forName(formDO.getTableClass());
        Map<String, String> data = this.multilingualRepoProc.query(tableClass, bizKey, fields = MultilingualCache.languageFields(tableClass));
        String translate = data.get("languageTranslation");
        if (translate == null) {
            return multilingualVO;
        }
        Map langPackVO = (Map)BeanUtils.toMap((String)translate, (TypeReference)new TypeReference<Map<String, Map<String, String>>>(){});
        ArrayList<MultilingualFieldVO> fieldList = new ArrayList<MultilingualFieldVO>();
        for (HistoryFieldVO field : fields) {
            MultilingualFieldVO fieldVO = new MultilingualFieldVO();
            fieldVO.setFieldCode(field.getFieldCode());
            fieldVO.setFieldName(field.getFieldName());
            fieldVO.setFieldValue(data.get(field.getFieldCode()));
            for (String langKey : langPackVO.keySet()) {
                Map fieldValues = (Map)langPackVO.get(langKey);
                fieldVO.addTranslation(langKey, (String)fieldValues.get(CharSequenceUtil.toUnderlineCase((CharSequence)field.getFieldCode())));
            }
            fieldList.add(fieldVO);
        }
        multilingualVO.setFields(fieldList);
        return multilingualVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateTranslate(MultilingualVO multilingualVO) {
        if (CollUtil.isEmpty(multilingualVO.getFields())) {
            logger.warn("[Multilingual] update multilingual fields is empty]");
            return false;
        }
        EnhanceFormDO formDO = this.enhanceFormRepoProc.findByFormCode(multilingualVO.getFormCode());
        if (formDO == null) {
            throw new IllegalArgumentException("\u8868\u5355(" + multilingualVO.getFormCode() + ")\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528");
        }
        return this.multilingualRepoProc.update(Class.forName(formDO.getTableClass()), multilingualVO) > 0L;
    }

    public MultilingualServiceImpl(MultilingualRepoProc multilingualRepoProc, EnhanceFormRepoProc enhanceFormRepoProc) {
        this.multilingualRepoProc = multilingualRepoProc;
        this.enhanceFormRepoProc = enhanceFormRepoProc;
    }
}

