package com.elitesland.cbpl.multilingual.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/12/04
 */
@Data
@ApiModel("导入导出，批处理参数")
public class MultilingualBatchVO {

    @ApiModelProperty("表单编码")
    @NotBlank(message = "表单编码必填")
    private String formCode;

    @ApiModelProperty("语种")
    private String language;

    @ApiModelProperty("翻译字段")
    private List<MultilingualFlatVO> data;
}
