package com.elitesland.cbpl.multilingual.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2024/12/02
 */
@Data
@ApiModel("需要翻译的字段")
public class MultilingualFieldVO {

    @ApiModelProperty("字段编码")
    private String fieldCode;

    @ApiModelProperty("字段名称")
    private String fieldName;

    @ApiModelProperty("字段值")
    private String fieldValue;

    @ApiModelProperty("多语言翻译")
    private Map<String, String> translate = new HashMap<>();

    public void addTranslation(String lang, String value) {
        translate.put(lang, value);
    }
}
