package com.elitesland.cbpl.multilingual.service;

import com.elitesland.cbpl.multilingual.domain.MultilingualBatchVO;
import com.elitesland.cbpl.multilingual.domain.MultilingualFlatVO;
import com.elitesland.cbpl.multilingual.domain.MultilingualVO;

import javax.validation.Valid;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/12/02
 */
public interface MultilingualService {

    /**
     * 查询翻译内容
     *
     * @param formCode 表单编码
     * @param bizKey   业务主键
     * @return 翻译内容
     */
    MultilingualVO queryTranslate(String formCode, Long bizKey);

    /**
     * 更新翻译内容
     *
     * @param multilingualVO 更新参数
     * @return 是否更新成功
     */
    Boolean updateTranslate(@Valid MultilingualVO multilingualVO);

    /**
     * 批量导出语言包
     *
     * @param paramVO 导出参数
     * @return 翻译数据
     */
    List<MultilingualFlatVO> exportData(@Valid MultilingualBatchVO paramVO);

    /**
     * 批量导入语言包
     *
     * @param paramVO 导入参数
     * @return 报错信息
     */
    List<String> importData(MultilingualBatchVO paramVO);
}
