/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.multilingual.cache;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.elitesland.cbpl.formgenerator.service.EnhanceFormFieldService;
import com.elitesland.cbpl.formgenerator.vo.resp.FormHistoryVO;
import com.elitesland.cbpl.formgenerator.vo.resp.HistoryFieldVO;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.util.StringUtils;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import com.elitesland.cbpl.tool.redis.util.RedisUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MultilingualCache {
    private static final String REDIS_LANGUAGE_KEY = "MULTILINGUAL_CACHE";
    private static final Cache<String, List<HistoryFieldVO>> LANGUAGE_CACHE = Caffeine.newBuilder().maximumSize(2000L).expireAfterWrite(Duration.ofMinutes(2L)).build();

    public static List<HistoryFieldVO> languageFields(Class<?> tableClass) {
        String languageKey = StringUtils.tenantKey((String[])new String[]{tableClass.getName()});
        List languageFields = (List)LANGUAGE_CACHE.getIfPresent((Object)languageKey);
        if (CollUtil.isNotEmpty((Collection)languageFields)) {
            return languageFields;
        }
        List<HistoryFieldVO> data = MultilingualCache.languageFieldsRedis(tableClass);
        LANGUAGE_CACHE.put((Object)languageKey, data);
        return (List)ObjectUtil.defaultIfNull(data, Collections.emptyList());
    }

    private static List<HistoryFieldVO> languageFieldsRedis(Class<?> tableClass) {
        String languageKey = StringUtils.tenantKey((String[])new String[]{tableClass.getName()});
        RedisUtil redisUtil = (RedisUtil)SpringUtils.getBean(RedisUtil.class);
        Object result = redisUtil.hget(REDIS_LANGUAGE_KEY, languageKey);
        if (result == null) {
            List<HistoryFieldVO> data = MultilingualCache.languageFieldsDatabase(tableClass);
            if (CollUtil.isEmpty(data)) {
                return Collections.emptyList();
            }
            redisUtil.hset(REDIS_LANGUAGE_KEY, languageKey, data);
            return data;
        }
        return BeanUtils.toList((String)JSONUtil.toJsonStr((Object)result), HistoryFieldVO.class);
    }

    private static List<HistoryFieldVO> languageFieldsDatabase(Class<?> tableClass) {
        String className = tableClass.getName();
        EnhanceFormFieldService fieldService = (EnhanceFormFieldService)SpringUtils.getBean(EnhanceFormFieldService.class);
        FormHistoryVO formVO = fieldService.queryEffectiveByTableClass(className);
        return fieldService.queryFieldsByFormCode(formVO.getFormCode(), formVO.getVersion());
    }

    public static void clearCache() {
        LANGUAGE_CACHE.invalidateAll();
        RedisUtil redisUtil = (RedisUtil)SpringUtils.getBean(RedisUtil.class);
        redisUtil.del(new String[]{REDIS_LANGUAGE_KEY});
    }
}

