/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.multilingual.common.repo;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.cbpl.multilingual.common.util.MultilingualUtil;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.stereotype.Component;

@Component
public class MultilingualQueryFactory {
    private final JPAQueryFactory jpaQueryFactory;

    public Map<String, Object> fetchOne(Class<?> tableClass, Function<PathBuilder<?>, Path<?>[]> fields, Function<PathBuilder<?>, Predicate> predicate) {
        PathBuilder<?> entity = MultilingualUtil.pathBuilder(tableClass);
        Path<?>[] paths = fields.apply(entity);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(paths).from(entity)).where(predicate.apply(entity));
        Tuple tuple = (Tuple)jpaQuery.fetchOne();
        if (tuple == null) {
            throw new IllegalArgumentException("[Multilingual] fetch data empty.");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Path<?> path : paths) {
            result.put(path.getMetadata().getName(), tuple.get(path));
        }
        return result;
    }

    public List<Map<String, Object>> fetch(Class<?> tableClass, Function<PathBuilder<?>, Path<?>[]> fields, Function<PathBuilder<?>, Predicate> predicate) {
        PathBuilder<?> entity = MultilingualUtil.pathBuilder(tableClass);
        Path<?>[] paths = fields.apply(entity);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(paths).from(entity)).where(predicate.apply(entity));
        List tupleList = jpaQuery.fetch();
        if (CollUtil.isEmpty((Collection)tupleList)) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Tuple tuple : tupleList) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            for (Path<?> path : paths) {
                rowData.put(path.getMetadata().getName(), tuple.get(path));
            }
            result.add(rowData);
        }
        return result;
    }

    public MultilingualQueryFactory(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

