/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.multilingual.controller;

import cn.hutool.core.lang.Assert;
import com.elitesland.cbpl.multilingual.cache.MultilingualCache;
import com.elitesland.cbpl.multilingual.domain.MultilingualVO;
import com.elitesland.cbpl.multilingual.service.MultilingualService;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u591a\u8bed\u8a00\u7ffb\u8bd1\u5de5\u5177"})
@RestController
@RequestMapping(value={"/multilingual"})
public class MultilingualController {
    private static final Logger logger = LoggerFactory.getLogger(MultilingualController.class);
    private final MultilingualService multilingualService;

    @ApiOperation(value="01.\u5355\u6761\u6570\u636e-\u591a\u8bed\u8a00\u7ffb\u8bd1")
    @GetMapping(value={"/queryTranslate"})
    public HttpResult<MultilingualVO> queryTranslate(String formCode, Long bizKey) {
        Assert.notBlank((CharSequence)formCode, (String)"\u8868\u5355\u7f16\u7801(formCode)\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)bizKey, (String)"\u4e1a\u52a1\u4e3b\u952e(bizKey)\u5fc5\u586b", (Object[])new Object[0]);
        logger.info("[Multilingual] query business data: {}, {}", (Object)formCode, (Object)bizKey);
        return HttpResult.ok((Object)this.multilingualService.queryTranslate(formCode, bizKey));
    }

    @ApiOperation(value="02.\u5355\u6761\u6570\u636e-\u66f4\u65b0\u7ffb\u8bd1\u5185\u5bb9")
    @PutMapping(value={"/updateTranslate"})
    public HttpResult<Boolean> updateTranslate(@RequestBody @Valid MultilingualVO multilingualVO) {
        logger.info("[Multilingual] update business translate: {}", (Object)multilingualVO);
        return HttpResult.ok((Object)this.multilingualService.updateTranslate(multilingualVO));
    }

    @ApiOperation(value="05.\u6e05\u9664\u6240\u6709\u7f13\u5b58\u7684\u7ffb\u8bd1\u5b57\u6bb5")
    @DeleteMapping(value={"/clear"})
    public HttpResult<List<String>> clearTranslate() {
        logger.info("[Multilingual] delete translate cache.");
        MultilingualCache.clearCache();
        return HttpResult.ok();
    }

    public MultilingualController(MultilingualService multilingualService) {
        this.multilingualService = multilingualService;
    }
}

