/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.multilingual.repo;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import com.elitesland.cbpl.formgenerator.vo.resp.HistoryFieldVO;
import com.elitesland.cbpl.multilingual.common.repo.MultilingualQueryFactory;
import com.elitesland.cbpl.multilingual.common.util.MultilingualUtil;
import com.elitesland.cbpl.multilingual.domain.MultilingualFieldVO;
import com.elitesland.cbpl.multilingual.domain.MultilingualVO;
import com.elitesland.cbpl.multilingual.spi.MultilingualPredicateSpi;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.unicom.util.UnicomClient;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MultilingualRepoProc {
    private static final Logger logger = LoggerFactory.getLogger(MultilingualRepoProc.class);
    private final JPAQueryFactory jpaQueryFactory;
    private final MultilingualQueryFactory multilingualQueryFactory;
    private final MultilingualPredicateSpi predicateSpi;

    public Map<String, Object> fetchOne(Class<?> tableClass, Long bizKey, List<HistoryFieldVO> fields) {
        try {
            return this.multilingualQueryFactory.fetchOne(tableClass, (PathBuilder<?> entity) -> {
                Object[] paths = new StringPath[]{};
                paths = (StringPath[])ArrayUtil.append((Object[])paths, (Object[])new StringPath[]{entity.getString("languageTranslation")});
                for (HistoryFieldVO field : fields) {
                    paths = (StringPath[])ArrayUtil.append((Object[])paths, (Object[])new StringPath[]{entity.getString(field.getFieldCode())});
                }
                return paths;
            }, (PathBuilder<?> entity) -> {
                NumberPath id = entity.getNumber("id", Long.class);
                return id.eq((Object)bizKey);
            });
        }
        catch (Throwable e) {
            Throwable error = ExceptionUtils.getCausedBy((Throwable)e);
            throw PhoenixException.unexpected((String)error.getMessage());
        }
    }

    public List<Map<String, Object>> fetch(String formCode, Class<?> tableClass, List<HistoryFieldVO> fields) {
        return this.multilingualQueryFactory.fetch(tableClass, (PathBuilder<?> entity) -> {
            Object[] paths = new Path[]{};
            paths = (Path[])ArrayUtil.append((Object[])paths, (Object[])new Path[]{entity.getNumber("id", Long.class)});
            paths = (Path[])ArrayUtil.append((Object[])paths, (Object[])new Path[]{entity.getString("languageTranslation")});
            for (HistoryFieldVO field : fields) {
                paths = (Path[])ArrayUtil.append((Object[])paths, (Object[])new Path[]{entity.getString(field.getFieldCode())});
            }
            return paths;
        }, (PathBuilder<?> entity) -> {
            ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
            NumberPath deleteFlag = entity.getNumber("deleteFlag", Integer.class);
            predicates.add(deleteFlag.eq((Object)0));
            try {
                UnicomClient.run(() -> this.predicateSpi.queryBuilder((PathBuilder<?>)entity, (List<Predicate>)predicates), (String)formCode);
            }
            catch (Exception e) {
                logger.warn("[Multilingual] custom predicates failed: {}", (Object)e.getMessage());
            }
            return ExpressionUtils.allOf(predicates);
        });
    }

    public long update(Class<?> tableClass, MultilingualVO multilingualVO) {
        PathBuilder<?> entity = MultilingualUtil.pathBuilder(tableClass);
        JPAUpdateClause update = this.jpaQueryFactory.update(entity);
        AtomicLong updateCount = new AtomicLong();
        Map<String, List<String>> params = this.updateParamBuilder(multilingualVO);
        params.forEach((lang, values) -> {
            StringPath languageTranslation = entity.getString("languageTranslation");
            MultilingualUtil.updateClause(update, languageTranslation, lang, values);
            NumberPath id = entity.getNumber("id", Long.class);
            update.where(new Predicate[]{id.eq((Object)multilingualVO.getBizKey())});
            long cnt = update.execute();
            updateCount.set(updateCount.get() + cnt);
        });
        return updateCount.get();
    }

    private Map<String, List<String>> updateParamBuilder(MultilingualVO multilingualVO) {
        HashMap<String, List<String>> fieldParams = new HashMap<String, List<String>>();
        for (MultilingualFieldVO field : multilingualVO.getFields()) {
            for (Map.Entry<String, String> entry : field.getTranslate().entrySet()) {
                ArrayList<String> fieldValues = (ArrayList<String>)fieldParams.get(entry.getKey());
                if (fieldValues == null) {
                    fieldValues = new ArrayList<String>();
                }
                fieldValues.add(CharSequenceUtil.toUnderlineCase((CharSequence)field.getFieldCode()));
                fieldValues.add(entry.getValue());
                fieldParams.put(entry.getKey(), fieldValues);
            }
        }
        return fieldParams;
    }

    public MultilingualRepoProc(JPAQueryFactory jpaQueryFactory, MultilingualQueryFactory multilingualQueryFactory, MultilingualPredicateSpi predicateSpi) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.multilingualQueryFactory = multilingualQueryFactory;
        this.predicateSpi = predicateSpi;
    }
}

