/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.multilingual.common.util;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.multilingual.common.db.constant.LangCondition;
import com.elitesland.cbpl.multilingual.common.util.MultilingualCommon;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MultilingualUtil
extends MultilingualCommon {
    public static void selectTransfer(JPAQuery<?> jpaQuery) {
        FactoryExpression projection = (FactoryExpression)jpaQuery.getMetadata().getProjection();
        List args = projection.getArgs();
        Object[] array = args.stream().map(expression -> {
            if (!(expression instanceof Path)) {
                return expression;
            }
            Path currPath = (Path)expression;
            PathMetadata metadata = currPath.getMetadata();
            Path rootPath = metadata.getRootPath();
            Class tableClass = rootPath.getType();
            if (!MultilingualUtil.translateRequired(tableClass, metadata.getName())) {
                return expression;
            }
            PathBuilder<?> entity = MultilingualUtil.pathBuilder(tableClass);
            StringPath path = entity.getString("languageTranslation");
            StringTemplate expr = Expressions.stringTemplate((String)"json_unquote(json_extract({0}, {1}))", (Object[])new Object[]{path, MultilingualUtil.translateField(metadata.getName())});
            return ((StringExpression)expr.when((Expression)Expressions.stringTemplate((String)"'null'", (Object[])new Object[0])).then((StringExpression)Expressions.stringTemplate((String)"null", (Object[])new Object[0])).otherwise((Expression)expr)).coalesce(new Expression[]{currPath}).as(metadata.getName());
        }).toArray();
        Expression[] expressions = (Expression[])Arrays.copyOf(array, array.length, Expression[].class);
        jpaQuery.select((Expression)Projections.bean((Class)projection.getType(), (Expression[])expressions));
    }

    public static List<Predicate> predicate(StringPath field, String value) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        MultilingualUtil.predicate(predicates, field, value);
        return predicates;
    }

    public static void predicate(List<Predicate> predicates, StringPath field, String value) {
        predicates.add(MultilingualUtil.predicateBuilder(field, value));
    }

    public static Predicate predicateBuilder(StringPath field, String value) {
        return MultilingualUtil.predicateBuilder(field, value, LangCondition.EQUALS.getCode());
    }

    public static List<Predicate> predicateLike(StringPath field, String value) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        MultilingualUtil.predicateLike(predicates, field, value);
        return predicates;
    }

    public static void predicateLike(List<Predicate> predicates, StringPath field, String value) {
        predicates.add(MultilingualUtil.predicateLikeBuilder(field, value));
    }

    public static Predicate predicateLikeBuilder(StringPath field, String value) {
        return MultilingualUtil.predicateBuilder(field, value, LangCondition.LIKE.getCode());
    }

    public static void updateClause(JPAUpdateClause update, StringPath column, Map<String, List<String>> updateParams) {
        updateParams.forEach((lang, values) -> {
            StringTemplate stringTemplate = Expressions.stringTemplate((String)"JSON_SET({0}, {1}, {2})", (Object[])new Object[]{column.coalesce("{}"), "$." + lang, Expressions.stringTemplate((String)SqlUtil.jsonObjectParam((int)values.size()), (List)values)});
            update.set((Path)column, (Expression)stringTemplate);
        });
    }

    public static void updateClause(JPAUpdateClause update, StringPath column, String lang, List<String> values) {
        StringTemplate stringTemplate = Expressions.stringTemplate((String)"JSON_SET({0}, {1}, {2})", (Object[])new Object[]{column.coalesce("{}"), "$." + lang, "JSON_OBJECT(" + StrUtil.join((CharSequence)",", values) + ")"});
        update.set((Path)column, (Expression)stringTemplate);
    }
}

