package com.elitesland.cbpl.multilingual.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/12/02
 */
@Data
@ApiModel("翻译内容")
public class MultilingualVO {

    @ApiModelProperty("表单编码")
    @NotBlank(message = "表单编码必填")
    private String formCode;

    @ApiModelProperty("业务主键(ID)")
    @NotNull(message = "业务主键(ID)必填")
    private Long bizKey;

    @ApiModelProperty("需要翻译的字段")
    private List<MultilingualFieldVO> fields;
}
