/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.multilingual.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.cbpl.formgenerator.entity.EnhanceFormDO;
import com.elitesland.cbpl.formgenerator.repo.EnhanceFormRepoProc;
import com.elitesland.cbpl.formgenerator.vo.resp.HistoryFieldVO;
import com.elitesland.cbpl.multilingual.cache.MultilingualCache;
import com.elitesland.cbpl.multilingual.domain.MultilingualBatchVO;
import com.elitesland.cbpl.multilingual.domain.MultilingualFieldVO;
import com.elitesland.cbpl.multilingual.domain.MultilingualFlatVO;
import com.elitesland.cbpl.multilingual.domain.MultilingualVO;
import com.elitesland.cbpl.multilingual.repo.MultilingualRepoProc;
import com.elitesland.cbpl.multilingual.service.MultilingualService;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MultilingualServiceImpl
implements MultilingualService {
    private static final Logger logger = LoggerFactory.getLogger(MultilingualServiceImpl.class);
    private final MultilingualRepoProc multilingualRepoProc;
    private final EnhanceFormRepoProc enhanceFormRepoProc;

    @Override
    public MultilingualVO queryTranslate(String formCode, Long bizKey) {
        List<HistoryFieldVO> fields;
        MultilingualVO multilingualVO = new MultilingualVO();
        multilingualVO.setFormCode(formCode);
        multilingualVO.setBizKey(bizKey);
        EnhanceFormDO formDO = this.enhanceFormRepoProc.findByFormCode(formCode);
        if (formDO == null) {
            throw new IllegalArgumentException("\u8868\u5355(" + formCode + ")\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528");
        }
        Class<?> tableClass = Class.forName(formDO.getTableClass());
        Map<String, Object> data = this.multilingualRepoProc.fetchOne(tableClass, bizKey, fields = MultilingualCache.languageFields(tableClass));
        Object translate = data.get("languageTranslation");
        String translateStr = translate == null ? "{}" : translate.toString();
        Map langPackVO = (Map)BeanUtils.toMap((String)translateStr, (TypeReference)new TypeReference<Map<String, Map<String, String>>>(){});
        ArrayList<MultilingualFieldVO> fieldList = new ArrayList<MultilingualFieldVO>();
        for (HistoryFieldVO field : fields) {
            MultilingualFieldVO fieldVO = new MultilingualFieldVO();
            fieldVO.setFieldCode(field.getFieldCode());
            fieldVO.setFieldName(field.getFieldName());
            fieldVO.setFieldValue(data.get(field.getFieldCode()) == null ? "" : data.get(field.getFieldCode()).toString());
            for (String langKey : langPackVO.keySet()) {
                Map fieldValues = (Map)langPackVO.get(langKey);
                fieldVO.addTranslation(langKey, (String)fieldValues.get(CharSequenceUtil.toUnderlineCase((CharSequence)field.getFieldCode())));
            }
            fieldList.add(fieldVO);
        }
        multilingualVO.setFields(fieldList);
        return multilingualVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateTranslate(MultilingualVO multilingualVO) {
        if (CollUtil.isEmpty(multilingualVO.getFields())) {
            logger.warn("[Multilingual] update multilingual fields is empty]");
            return false;
        }
        EnhanceFormDO formDO = this.enhanceFormRepoProc.findByFormCode(multilingualVO.getFormCode());
        if (formDO == null) {
            throw new IllegalArgumentException("\u8868\u5355(" + multilingualVO.getFormCode() + ")\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528");
        }
        return this.multilingualRepoProc.update(Class.forName(formDO.getTableClass()), multilingualVO) > 0L;
    }

    @Override
    public List<MultilingualFlatVO> exportData(MultilingualBatchVO paramVO) {
        ArrayList<MultilingualFlatVO> result = new ArrayList<MultilingualFlatVO>();
        EnhanceFormDO formDO = this.enhanceFormRepoProc.findByFormCode(paramVO.getFormCode());
        if (formDO == null) {
            throw new IllegalArgumentException("\u8868\u5355(" + paramVO.getFormCode() + ")\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528");
        }
        Class<?> tableClass = Class.forName(formDO.getTableClass());
        List<HistoryFieldVO> fields = MultilingualCache.languageFields(tableClass);
        List<Map<String, Object>> dataList = this.multilingualRepoProc.fetch(tableClass, fields);
        for (Map<String, Object> data : dataList) {
            for (HistoryFieldVO field : fields) {
                Map langPackVO;
                MultilingualFlatVO exportVO = new MultilingualFlatVO();
                exportVO.setFormCode(paramVO.getFormCode());
                exportVO.setBizKey(String.valueOf(data.get("id")));
                exportVO.setFieldCode(field.getFieldCode());
                exportVO.setFieldName(field.getFieldName());
                exportVO.setFieldValue(String.valueOf(data.get(field.getFieldCode())));
                String translate = String.valueOf(data.get("languageTranslation"));
                if (paramVO.getLanguage() != null && translate != null && (langPackVO = (Map)BeanUtils.toMap((String)translate, (TypeReference)new TypeReference<Map<String, Map<String, String>>>(){})) != null) {
                    langPackVO.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(paramVO.getLanguage())).forEach(entry -> exportVO.setTranslate((String)((Map)entry.getValue()).get(CharSequenceUtil.toUnderlineCase((CharSequence)field.getFieldCode()))));
                }
                result.add(exportVO);
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> importData(MultilingualBatchVO paramVO) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        EnhanceFormDO formDO = this.enhanceFormRepoProc.findByFormCode(paramVO.getFormCode());
        if (formDO == null) {
            throw new IllegalArgumentException("\u8868\u5355(" + paramVO.getFormCode() + ")\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528");
        }
        Map<String, List<MultilingualFlatVO>> collect = paramVO.getData().stream().collect(Collectors.groupingBy(MultilingualFlatVO::getBizKey));
        ArrayList importData = new ArrayList();
        collect.forEach((bizKey, values) -> {
            MultilingualVO multilingualVO = new MultilingualVO();
            multilingualVO.setFormCode(paramVO.getFormCode());
            multilingualVO.setBizKey(Long.valueOf(bizKey));
            ArrayList<MultilingualFieldVO> fieldList = new ArrayList<MultilingualFieldVO>();
            for (MultilingualFlatVO field : values) {
                MultilingualFieldVO fieldVO = new MultilingualFieldVO();
                fieldVO.setFieldCode(field.getFieldCode());
                fieldVO.setFieldName(field.getFieldName());
                fieldVO.addTranslation(paramVO.getLanguage(), field.getTranslate());
                fieldList.add(fieldVO);
            }
            multilingualVO.setFields(fieldList);
            importData.add(multilingualVO);
        });
        Class<?> tableClass = Class.forName(formDO.getTableClass());
        importData.forEach(row -> this.multilingualRepoProc.update(tableClass, (MultilingualVO)row));
        return errorMessages;
    }

    public MultilingualServiceImpl(MultilingualRepoProc multilingualRepoProc, EnhanceFormRepoProc enhanceFormRepoProc) {
        this.multilingualRepoProc = multilingualRepoProc;
        this.enhanceFormRepoProc = enhanceFormRepoProc;
    }
}

