package com.elitesland.cbpl.online.controller;

import com.elitesland.cbpl.online.constant.OnlineConstant;
import com.elitesland.cbpl.online.service.OnlineService;
import com.elitesland.cbpl.online.vo.query.StatisticsPagingParamVO;
import com.elitesland.cbpl.online.vo.resp.OnlineSnapshotVO;
import com.elitesland.cbpl.online.vo.resp.OnlineStatisticsVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/11/25
 */
@Slf4j
@Api(tags = "在线人数统计")
@RestController
@RequestMapping("/online")
@RequiredArgsConstructor
public class OnlineController {

    private final OnlineService onlineService;

    @ApiOperation(value = "01.更新用户在线统计表")
    @PostMapping(value = "/sync")
    public HttpResult<?> batchSync() {
        logger.info("[Online] batch sync statistics.");
        onlineService.batchSync();
        return HttpResult.ok();
    }

    @ApiOperation(value = "02.生成快照")
    @PostMapping(value = "/snapshot")
    public HttpResult<?> snapshot() {
        logger.info("[Online] create new snapshot.");
        onlineService.snapshot(OnlineConstant.SNAPSHOT_TYPE_INVOKE);
        return HttpResult.ok();
    }

    @ApiOperation(value = "03.当前在线用户查询")
    @PostMapping(value = "/paging")
    public HttpResult<PagingVO<OnlineStatisticsVO>> paging(@RequestBody StatisticsPagingParamVO query) {
        logger.info("[Online] query paging param: {}", query);
        return HttpResult.ok(onlineService.paging(query));
    }

    @ApiOperation(value = "04.查询快照报表")
    @GetMapping(value = "/snapshot/query")
    public HttpResult<List<OnlineSnapshotVO>> querySnapshot(Integer type, LocalDateTime fromDate, LocalDateTime toDate) {
        logger.info("[Online] query snapshot chart.");
        return HttpResult.ok(onlineService.querySnapshot(type, fromDate, toDate));
    }
}
