package com.elitesland.cbpl.online.data.repo;

import com.elitesland.cbpl.online.data.entity.OnlineSnapshotDO;
import com.elitesland.cbpl.online.data.entity.QOnlineSnapshotDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/11/26
 */
@Component
@RequiredArgsConstructor
public class OnlineSnapshotRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QOnlineSnapshotDO snapshotDO = QOnlineSnapshotDO.onlineSnapshotDO;

    public List<OnlineSnapshotDO> querySnapshot(Integer type, LocalDateTime fromDate, LocalDateTime toDate) {
        var jpaQuery = jpaQueryFactory.select(snapshotDO)
                .from(snapshotDO);
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(snapshotDO.deleteFlag.eq(0));
        // 起止日期都有
        if (fromDate != null && toDate != null) {
            predicates.add(snapshotDO.snapshotTime.between(fromDate, toDate));
        }
        // 都没有时，仅返回当天
        else {
            predicates.add(snapshotDO.snapshotTime.goe(LocalDate.now().atStartOfDay()));
        }
        if (type != null) {
            predicates.add(snapshotDO.type.eq(type));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }
}
