package com.elitesland.cbpl.online.service;

import com.elitesland.cbpl.online.vo.query.StatisticsPagingParamVO;
import com.elitesland.cbpl.online.vo.resp.OnlineSnapshotVO;
import com.elitesland.cbpl.online.vo.resp.OnlineStatisticsVO;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.tool.websocket.handler.domain.OnlineUser;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/11/15
 */
public interface OnlineService {

    /**
     * 操作日志 - 上线/下线，登记
     * <li>存储方式：redis、mysql</li>
     */
    void record(OnlineUser onlineUser);

    /**
     * 操作日志 - 批处理持久化
     * <li>1. 定期更新至，用户在线统计表</li>
     * <li>2. 活跃状态，同时进行更新</li>
     */
    void batchSync();

    /**
     * 实时在线用户数 - 生成快照
     *
     * @param type 统计方式：1定时统计，2手动统计；
     */
    void snapshot(int type);

    /**
     * 操作日志 - 定期删除
     */
    void deletion();

    /**
     * 用户在线状态 - 分页查询
     */
    PagingVO<OnlineStatisticsVO> paging(StatisticsPagingParamVO query);

    /**
     * 查询快照数据
     *
     * @param type     生成快照方式
     * @param fromDate 起始日期
     * @param toDate   结束日期
     */
    List<OnlineSnapshotVO> querySnapshot(Integer type, LocalDateTime fromDate, LocalDateTime toDate);
}
