/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.online.controller;

import com.elitesland.cbpl.online.service.OnlineService;
import com.elitesland.cbpl.online.vo.query.StatisticsPagingParamVO;
import com.elitesland.cbpl.online.vo.resp.OnlineSnapshotVO;
import com.elitesland.cbpl.online.vo.resp.OnlineStatisticsVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5728\u7ebf\u4eba\u6570\u7edf\u8ba1"})
@RestController
@RequestMapping(value={"/online"})
public class OnlineController {
    private static final Logger logger = LoggerFactory.getLogger(OnlineController.class);
    private final OnlineService onlineService;

    @ApiOperation(value="01.\u66f4\u65b0\u7528\u6237\u5728\u7ebf\u7edf\u8ba1\u8868")
    @PostMapping(value={"/sync"})
    public HttpResult<?> batchSync() {
        logger.info("[Online] batch sync statistics.");
        this.onlineService.batchSync();
        return HttpResult.ok();
    }

    @ApiOperation(value="02.\u751f\u6210\u5feb\u7167")
    @PostMapping(value={"/snapshot"})
    public HttpResult<?> snapshot() {
        logger.info("[Online] create new snapshot.");
        this.onlineService.snapshot(2);
        return HttpResult.ok();
    }

    @ApiOperation(value="03.\u5f53\u524d\u5728\u7ebf\u7528\u6237\u67e5\u8be2")
    @PostMapping(value={"/paging"})
    public HttpResult<PagingVO<OnlineStatisticsVO>> paging(@RequestBody StatisticsPagingParamVO query) {
        logger.info("[Online] query paging param: {}", (Object)query);
        return HttpResult.ok(this.onlineService.paging(query));
    }

    @ApiOperation(value="04.\u67e5\u8be2\u5feb\u7167\u62a5\u8868")
    @GetMapping(value={"/snapshot/query"})
    public HttpResult<List<OnlineSnapshotVO>> querySnapshot(Integer type, LocalDateTime fromDate, LocalDateTime toDate) {
        logger.info("[Online] query snapshot chart.");
        return HttpResult.ok(this.onlineService.querySnapshot(type, fromDate, toDate));
    }

    public OnlineController(OnlineService onlineService) {
        this.onlineService = onlineService;
    }
}

