/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.online.data.repo;

import com.elitesland.cbpl.online.data.entity.OnlineSnapshotDO;
import com.elitesland.cbpl.online.data.entity.QOnlineSnapshotDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class OnlineSnapshotRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QOnlineSnapshotDO snapshotDO = QOnlineSnapshotDO.onlineSnapshotDO;

    public List<OnlineSnapshotDO> querySnapshot(Integer type, LocalDateTime fromDate, LocalDateTime toDate) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)snapshotDO).from((EntityPath)snapshotDO);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(OnlineSnapshotRepoProc.snapshotDO.deleteFlag.eq((Object)0));
        if (fromDate != null && toDate != null) {
            predicates.add(OnlineSnapshotRepoProc.snapshotDO.snapshotTime.between((Comparable)fromDate, (Comparable)toDate));
        } else {
            predicates.add(OnlineSnapshotRepoProc.snapshotDO.snapshotTime.goe((Comparable)LocalDate.now().atStartOfDay()));
        }
        if (type != null) {
            predicates.add(OnlineSnapshotRepoProc.snapshotDO.type.eq((Object)type));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    public OnlineSnapshotRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

