-- 在线人数统计-操作日志
create table sys_online_log
(
    id             bigint           not null comment '主键',
    sid            varchar(64)      null comment '会话ID',
    uid            varchar(64)      null comment '用户ID',
    username       varchar(64)      null comment '登录账号',
    nickname       varchar(64)      null comment '昵称',
    type           varchar(2)       null comment '登记类型：1上线，0下线；',
    ip             varchar(32)      null comment '客户端IP',
    country        varchar(64)      null comment 'IP国家',
    province       varchar(64)      null comment 'IP省份',
    city           varchar(64)      null comment 'IP城市',
    now            datetime(6)      null comment '登记时间',
    custom_fields  text             null comment '自定义字段(JSON字符串)',
    tenant_id      bigint DEFAULT '-1' COMMENT '租户ID',
    remark         varchar(255)     null comment '备注',
    create_user_id bigint           null comment '记录创建者ID',
    creator        varchar(255)     null comment '记录创建者',
    create_time    datetime(6)      null comment '记录创建时间',
    modify_user_id bigint           null comment '记录最后更新者ID',
    updater        varchar(255)     null comment '记录最后更新者',
    modify_time    datetime(6)      null comment '记录最后更新时间',
    delete_flag    int    default 0 null comment '删除标记',
    primary key (`id`)
) comment = '在线人数统计-操作日志';

-- 在线人数统计-实时统计
create table sys_online_statistics
(
    id               bigint           not null comment '主键',
    sid              varchar(64)      null comment '会话ID',
    uid              varchar(64)      null comment '用户ID',
    username         varchar(64)      null comment '登录账号',
    nickname         varchar(64)      null comment '昵称',
    status           varchar(2)       null comment '当前状态：1在线，0离线；',
    ip               varchar(32)      null comment '客户端IP',
    country          varchar(64)      null comment 'IP国家',
    province         varchar(64)      null comment 'IP省份',
    city             varchar(64)      null comment 'IP城市',
    last_active_time datetime(6)      null comment '最后活跃时间',
    custom_fields    text             null comment '自定义字段(JSON字符串)',
    tenant_id        bigint DEFAULT '-1' COMMENT '租户ID',
    remark           varchar(255)     null comment '备注',
    create_user_id   bigint           null comment '记录创建者ID',
    creator          varchar(255)     null comment '记录创建者',
    create_time      datetime(6)      null comment '记录创建时间',
    modify_user_id   bigint           null comment '记录最后更新者ID',
    updater          varchar(255)     null comment '记录最后更新者',
    modify_time      datetime(6)      null comment '记录最后更新时间',
    delete_flag      int    default 0 null comment '删除标记',
    primary key (`id`)
) comment = '在线人数统计-实时统计';

-- 在线人数统计-快照
create table sys_online_snapshot
(
    id             bigint           not null comment '主键',
    user_count     int(11)          null comment '会话ID',
    session_count  int(11)          null comment '用户ID',
    type           varchar(2)       null comment '数据生成方式：1定时统计，2手动统计；',
    snapshot_time  datetime(6)      null comment '最后活跃时间',
    custom_fields  text             null comment '自定义字段(JSON字符串)',
    tenant_id      bigint DEFAULT '-1' COMMENT '租户ID',
    remark         varchar(255)     null comment '备注',
    create_user_id bigint           null comment '记录创建者ID',
    creator        varchar(255)     null comment '记录创建者',
    create_time    datetime(6)      null comment '记录创建时间',
    modify_user_id bigint           null comment '记录最后更新者ID',
    updater        varchar(255)     null comment '记录最后更新者',
    modify_time    datetime(6)      null comment '记录最后更新时间',
    delete_flag    int    default 0 null comment '删除标记',
    primary key (`id`)
) comment = '在线人数统计-快照';