package com.elitesland.cbpl.online.data.convert;

import com.elitesland.cbpl.online.data.entity.OnlineLogDO;
import com.elitesland.cbpl.online.vo.OnlineLogVO;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

/**
 * @author eric.hao
 * @since 2024/11/24
 */
@Mapper(config = BaseMapperConfig.class)
public interface OnlineLogConvert {

    OnlineLogConvert INSTANCE = Mappers.getMapper(OnlineLogConvert.class);

    /**
     * SaveParam => DO
     */
    @Mapping(target = "ip", expression = "java(parseRegionIp(saveParam))")
    @Mapping(target = "country", expression = "java(parseRegionCountry(saveParam))")
    @Mapping(target = "province", expression = "java(parseRegionProvince(saveParam))")
    @Mapping(target = "city", expression = "java(parseRegionCity(saveParam))")
    OnlineLogDO saveParamToDO(OnlineLogVO saveParam);

    @Named("parseRegionIp")
    default String parseRegionIp(OnlineLogVO saveParam) {
        if (saveParam == null) {
            return null;
        }
        if (saveParam.getRegion() == null) {
            return null;
        }
        return saveParam.getRegion().getIp();
    }

    @Named("parseRegionCountry")
    default String parseRegionCountry(OnlineLogVO saveParam) {
        if (saveParam == null) {
            return null;
        }
        if (saveParam.getRegion() == null) {
            return null;
        }
        return saveParam.getRegion().getCountry();
    }

    @Named("parseRegionProvince")
    default String parseRegionProvince(OnlineLogVO saveParam) {
        if (saveParam == null) {
            return null;
        }
        if (saveParam.getRegion() == null) {
            return null;
        }
        return saveParam.getRegion().getProvince();
    }

    @Named("parseRegionCity")
    default String parseRegionCity(OnlineLogVO saveParam) {
        if (saveParam == null) {
            return null;
        }
        if (saveParam.getRegion() == null) {
            return null;
        }
        return saveParam.getRegion().getCity();
    }
}
