package com.elitesland.cbpl.online.data.entity;

import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 在线人数统计-快照
 *
 * @author eric.hao
 * @since 2024/11/24
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_online_snapshot")
@org.hibernate.annotations.Table(appliesTo = "sys_online_snapshot", comment = "在线人数统计-快照")
@ApiModel("在线人数统计-快照")
public class OnlineSnapshotDO extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 7162109142287865539L;

    @Column
    @Comment("当前在线人数")
    private int onlineCount;

    @Column
    @Comment("数据生成方式：1定时统计，2手动统计；")
    private int type;

    @Column
    @Comment("登记快照时间")
    private LocalDateTime snapshotTime;
}
