package com.elitesland.cbpl.online.service;

import com.elitesland.cbpl.tool.websocket.handler.domain.OnlineUser;

/**
 * @author eric.hao
 * @since 2024/11/15
 */
public interface OnlineService {

    /**
     * 操作日志 - 上线/下线，登记
     * <li>存储方式：redis、mysql</li>
     */
    void record(OnlineUser onlineUser);

    /**
     * 操作日志 - 批处理持久化
     * <li>1. 定期更新至，用户在线统计表</li>
     * <li>2. 活跃状态，同时进行更新</li>
     * <li>4. 不活跃用户，更新为离线</li>
     * <li>5. 不活跃时长需要读配置</li>
     */
    void batchSync();

    /**
     * 实时在线用户数 - 生成快照
     */
    void snapshot();

    /**
     * 操作日志 - 定期删除
     */
    void deletion();

    /**
     * 用户在线状态 - 分页查询
     */
    void paging();
}
