package com.elitesland.cbpl.online.vo;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 实时在线人数统计
 *
 * @author eric.hao
 * @since 2024/11/19
 */
@Data
public class OnlineStatisticsVO {

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 登录账号
     */
    private String username;

    /**
     * 昵称
     */
    private String lastname;

    /**
     * 当前状态：1在线，2离线；
     */
    private String status;

    @JsonProperty
    public String getStatus() {
        if (CollUtil.isEmpty(regions)) {
            return "离线";
        }
        return "在线";
    }

    /**
     * 登录用户归属地
     */
    private List<OnlineRegionVO> regions;

    /**
     * 最后活跃时间
     */
    private LocalDateTime lastActiveTime;
}
