/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.online.config;

import com.elitesland.cbpl.online.config.OnlineProperties;
import com.elitesland.cbpl.online.data.repo.OnlineLogRepo;
import com.elitesland.cbpl.online.service.OnlineService;
import com.elitesland.cbpl.online.service.OnlineServiceImpl;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.support.ThreadPoolBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OnlineProperties.class})
@ConditionalOnProperty(prefix="cbpl.tool.ws", name={"enabled"}, havingValue="true")
public class OnlineAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OnlineAutoConfiguration.class);

    @Bean(value={"onlineTp"})
    public DtpExecutor onlineTp(OnlineProperties properties) {
        logger.info("[ONLINE] online properties: {}", (Object)properties);
        return ThreadPoolBuilder.newBuilder().threadPoolName(properties.getThreadPoolName()).threadFactory(properties.getThreadPrefix()).corePoolSize(properties.getCorePoolSize()).maximumPoolSize(properties.getMaximumPoolSize()).queueCapacity(properties.getQueueCapacity()).rejectedExecutionHandler(properties.getRejectPolicy()).eager().buildDynamic();
    }

    @Bean
    @ConditionalOnClass
    public OnlineService onlineService(OnlineLogRepo onlineLogRepo) {
        return new OnlineServiceImpl(onlineLogRepo);
    }
}

