/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.online.service;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.online.data.convert.OnlineLogConvert;
import com.elitesland.cbpl.online.data.repo.OnlineLogRepo;
import com.elitesland.cbpl.online.service.OnlineService;
import com.elitesland.cbpl.online.vo.OnlineLogVO;
import com.elitesland.cbpl.online.vo.OnlineRegionVO;
import com.elitesland.cbpl.tool.log.MDCUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import com.elitesland.cbpl.tool.websocket.handler.domain.OnlineUser;
import java.util.Map;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.transaction.annotation.Transactional;

public class OnlineServiceImpl
implements OnlineService {
    private static final Logger logger = LoggerFactory.getLogger(OnlineServiceImpl.class);
    private final OnlineLogRepo onlineLogRepo;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void record(OnlineUser onlineUser) {
        Map ctx = MDC.getCopyOfContextMap();
        String tenantCode = onlineUser.getTenantCode();
        DtpExecutor dtpExecutor = DtpRegistry.getDtpExecutor((String)"onlineTp");
        dtpExecutor.execute(() -> {
            MDCUtil.setContextMap((Map)ctx);
            if (StrUtil.isBlank((CharSequence)tenantCode)) {
                this.executor(onlineUser);
            } else {
                TenantSpiUtil.setCurrentTenant((String)tenantCode);
                this.executor(onlineUser);
                TenantSpiUtil.resetCurrentTenant();
            }
        });
    }

    private void executor(OnlineUser onlineUser) {
        OnlineLogVO logVO = new OnlineLogVO();
        logVO.setSid(onlineUser.getSessionId());
        logVO.setUid(onlineUser.getUid());
        logVO.setUsername(onlineUser.getUsername());
        logVO.setNickname(onlineUser.getNickname());
        logVO.setType(onlineUser.getSession().isOpen() ? 1 : 0);
        OnlineRegionVO region = new OnlineRegionVO();
        region.setIp(onlineUser.getIp());
        logVO.setRegion(region);
        logVO.setNow(onlineUser.getNow());
        this.onlineLogRepo.save(OnlineLogConvert.INSTANCE.saveParamToDO(logVO));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSync() {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void snapshot() {
    }

    @Override
    public void deletion() {
    }

    @Override
    public void paging() {
    }

    public OnlineServiceImpl(OnlineLogRepo onlineLogRepo) {
        this.onlineLogRepo = onlineLogRepo;
    }
}

