package com.elitesland.cbpl.online.controller;

import com.elitesland.cbpl.online.constant.OnlineConstant;
import com.elitesland.cbpl.online.service.OnlineService;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author eric.hao
 * @since 2024/11/25
 */
@Slf4j
@Api(tags = "在线人数统计")
@RestController
@RequestMapping("/online")
@RequiredArgsConstructor
public class OnlineController {

    private final OnlineService onlineService;

    @ApiOperation(value = "生成快照")
    @PostMapping(value = "/snapshot")
    public HttpResult<?> snapshot() {
        logger.info("[Online] create new snapshot.");
        onlineService.snapshot(OnlineConstant.SNAPSHOT_TYPE_INVOKE);
        return HttpResult.ok();
    }
}
