/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.online.service;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.online.data.convert.OnlineLogConvert;
import com.elitesland.cbpl.online.data.convert.OnlineStatisticsConvert;
import com.elitesland.cbpl.online.data.entity.OnlineSnapshotDO;
import com.elitesland.cbpl.online.data.entity.OnlineStatisticsDO;
import com.elitesland.cbpl.online.data.repo.OnlineLogRepo;
import com.elitesland.cbpl.online.data.repo.OnlineLogRepoProc;
import com.elitesland.cbpl.online.data.repo.OnlineSnapshotRepo;
import com.elitesland.cbpl.online.data.repo.OnlineStatisticsRepo;
import com.elitesland.cbpl.online.data.repo.OnlineStatisticsRepoProc;
import com.elitesland.cbpl.online.service.OnlineService;
import com.elitesland.cbpl.online.vo.query.StatisticsPagingParamVO;
import com.elitesland.cbpl.online.vo.resp.OnlineLogVO;
import com.elitesland.cbpl.online.vo.resp.OnlineStatisticsVO;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.tool.log.MDCUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import com.elitesland.cbpl.tool.websocket.handler.domain.OnlineUser;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OnlineServiceImpl
implements OnlineService {
    private static final Logger logger = LoggerFactory.getLogger(OnlineServiceImpl.class);
    private final OnlineLogRepo onlineLogRepo;
    private final OnlineLogRepoProc onlineLogRepoProc;
    private final OnlineStatisticsRepo statisticsRepo;
    private final OnlineStatisticsRepoProc statisticsRepoProc;
    private final OnlineSnapshotRepo snapshotRepo;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void record(OnlineUser onlineUser) {
        Map ctx = MDC.getCopyOfContextMap();
        String tenantCode = onlineUser.getTenantCode();
        DtpExecutor dtpExecutor = DtpRegistry.getDtpExecutor((String)"onlineTp");
        dtpExecutor.execute(() -> {
            MDCUtil.setContextMap((Map)ctx);
            if (StrUtil.isBlank((CharSequence)tenantCode)) {
                this.executor(onlineUser);
            } else {
                TenantSpiUtil.setCurrentTenant((String)tenantCode);
                this.executor(onlineUser);
                TenantSpiUtil.resetCurrentTenant();
            }
        });
    }

    private void executor(OnlineUser onlineUser) {
        OnlineLogVO logVO = new OnlineLogVO();
        logVO.setSid(onlineUser.getSessionId());
        logVO.setUid(onlineUser.getUid());
        logVO.setUsername(onlineUser.getUsername());
        logVO.setNickname(onlineUser.getNickname());
        logVO.setType(onlineUser.getSession().isOpen() ? 1 : 0);
        logVO.setIp(onlineUser.getIp());
        logVO.setNow(onlineUser.getNow());
        this.onlineLogRepo.save(OnlineLogConvert.INSTANCE.saveParamToDO(logVO));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSync() {
        List<OnlineLogVO> logs = this.onlineLogRepoProc.queryCurrentStatus();
        List<OnlineStatisticsDO> statistics = OnlineStatisticsConvert.INSTANCE.saveParamToDO(logs);
        for (OnlineStatisticsDO curr : statistics) {
            if (this.statisticsRepoProc.updateStatus(curr) != 0L) continue;
            this.statisticsRepo.save(curr);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void snapshot(int type) {
        List<OnlineStatisticsDO> statistics = this.statisticsRepoProc.queryCurrentOnline();
        long userCount = statistics.stream().map(OnlineStatisticsDO::getUid).distinct().count();
        OnlineSnapshotDO snapshotDO = new OnlineSnapshotDO();
        snapshotDO.setUserCount(userCount);
        snapshotDO.setSessionCount(statistics.size());
        snapshotDO.setType(type);
        snapshotDO.setSnapshotTime(LocalDateTime.now());
        this.snapshotRepo.save(snapshotDO);
    }

    @Override
    public void deletion() {
    }

    @Override
    public PagingVO<OnlineStatisticsVO> paging(StatisticsPagingParamVO query) {
        long count = this.statisticsRepoProc.statisticsCountBy(query);
        if (count > 0L) {
            List<OnlineStatisticsDO> list = this.statisticsRepoProc.statisticsPageBy(query);
            return new PagingVO(count, OnlineStatisticsConvert.INSTANCE.doToVO(list));
        }
        return new PagingVO();
    }

    public OnlineServiceImpl(OnlineLogRepo onlineLogRepo, OnlineLogRepoProc onlineLogRepoProc, OnlineStatisticsRepo statisticsRepo, OnlineStatisticsRepoProc statisticsRepoProc, OnlineSnapshotRepo snapshotRepo) {
        this.onlineLogRepo = onlineLogRepo;
        this.onlineLogRepoProc = onlineLogRepoProc;
        this.statisticsRepo = statisticsRepo;
        this.statisticsRepoProc = statisticsRepoProc;
        this.snapshotRepo = snapshotRepo;
    }
}

