package com.elitesland.cbpl.online.data.entity;

import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 在线人数统计-实时统计
 *
 * @author eric.hao
 * @since 2024/11/24
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_online_statistics")
@org.hibernate.annotations.Table(appliesTo = "sys_online_statistics", comment = "在线人数统计-实时统计")
@ApiModel("在线人数统计-实时统计")
public class OnlineStatisticsDO extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 7162109142287865539L;

    @Column
    @Comment("会话ID")
    private String sid;

    @Column
    @Comment("用户ID")
    private String uid;

    @Column
    @Comment("登录账号")
    private String username;

    @Column
    @Comment("昵称")
    private String nickname;

    @Column
    @Comment("当前状态：1在线，0离线；")
    private String status;

    @Column
    @Comment("客户端IP")
    private String ip;

    @Column
    @Comment("IP国家")
    private String country;

    @Column
    @Comment("IP省份")
    private String province;

    @Column
    @Comment("IP城市")
    private String city;

    @Column
    @Comment("最后活跃时间")
    private LocalDateTime lastActiveTime;
}
