package com.elitesland.cbpl.online.util;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.online.constant.OnlineConstant;
import com.elitesland.cbpl.tool.log.MDCUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import com.elitesland.cbpl.tool.websocket.handler.domain.OnlineUser;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.slf4j.MDC;

import java.util.Map;
import java.util.function.Consumer;

/**
 * @author eric.hao
 * @since 2024/11/25
 */
public class OnlineThreadUtil {

    public void wrapper(OnlineUser onlineUser, Consumer<OnlineUser> consumer) {
        // MDC上下文
        Map<String, String> ctx = MDC.getCopyOfContextMap();
        // 获取租户编码
        String tenantCode = onlineUser.getTenantCode();
        DtpExecutor dtpExecutor = DtpRegistry.getDtpExecutor(OnlineConstant.TP_ONLINE_POOL_NAME);
        dtpExecutor.execute(() -> {
            MDCUtil.setContextMap(ctx);
            // 租户不隔离
            if (StrUtil.isBlank(tenantCode)) {
                consumer.accept(onlineUser);
            }
            // 按租户隔离
            else {
                TenantSpiUtil.setCurrentTenant(tenantCode);
                consumer.accept(onlineUser);
                TenantSpiUtil.resetCurrentTenant();
            }
        });
    }
}
