package com.elitesland.cbpl.online.data.repo;

import com.elitesland.cbpl.online.data.entity.OnlineLogDO;
import com.elitesland.cbpl.online.data.entity.QOnlineLogDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/11/25
 */
@Component
@RequiredArgsConstructor
public class OnlineLogRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QOnlineLogDO onlineLogDO = QOnlineLogDO.onlineLogDO;

    //    select t.sid,
//    t.uid,
//    t.username,
//    t.nickname,
//    t.type,
//    t.ip,
//    t.country,
//    t.province,
//    t.city,
//    t.now
//    from (select max(id) as id
//    from sys_online_log
//    where delete_flag = 0
//    group by sid, uid) r
//    inner join sys_online_log t
//    on t.id = r.id
//    group by t.now;
    public List<OnlineLogDO> queryCurrentStatus() {
        var subQuery = jpaQueryFactory.select(onlineLogDO.id.max())
                .from(onlineLogDO).where(onlineLogDO.deleteFlag.eq(0))
                .groupBy(onlineLogDO.sid, onlineLogDO.uid);
        var jpaQuery = jpaQueryFactory.select(onlineLogDO)
                .from(onlineLogDO)
                .where(onlineLogDO.id.in(subQuery));
        return jpaQuery.fetch();
    }
}
