package com.elitesland.cbpl.online.task;

import com.elitesland.cbpl.online.constant.OnlineConstant;
import com.elitesland.cbpl.online.service.OnlineService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author eric.hao
 * @since 2024/11/26
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class OnlineTaskController {

    private final OnlineService onlineService;

    /**
     * 定时生成快照
     */
    public void snapshotAuto() {
        logger.info("[Online] auto create snapshot.");
        onlineService.snapshot(OnlineConstant.SNAPSHOT_TYPE_AUTO);
    }
}
