/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.online.data.repo;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.online.data.entity.OnlineStatisticsDO;
import com.elitesland.cbpl.online.data.entity.QOnlineStatisticsDO;
import com.elitesland.cbpl.online.vo.query.StatisticsPagingParamVO;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class OnlineStatisticsRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QOnlineStatisticsDO statisticsDO = QOnlineStatisticsDO.onlineStatisticsDO;

    public long updateStatus(OnlineStatisticsDO curr) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(OnlineStatisticsRepoProc.statisticsDO.sid.eq((Object)curr.getSid()));
        predicates.add(OnlineStatisticsRepoProc.statisticsDO.uid.eq((Object)curr.getUid()));
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)statisticsDO).set((Path)OnlineStatisticsRepoProc.statisticsDO.status, (Object)curr.getStatus()).set((Path)OnlineStatisticsRepoProc.statisticsDO.ip, (Object)curr.getIp()).set((Path)OnlineStatisticsRepoProc.statisticsDO.country, (Object)curr.getCountry()).set((Path)OnlineStatisticsRepoProc.statisticsDO.province, (Object)curr.getProvince()).set((Path)OnlineStatisticsRepoProc.statisticsDO.city, (Object)curr.getCity()).set(OnlineStatisticsRepoProc.statisticsDO.lastActiveTime, (Object)curr.getLastActiveTime()).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return update.execute();
    }

    public List<OnlineStatisticsDO> queryCurrentOnline() {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(OnlineStatisticsRepoProc.statisticsDO.deleteFlag.eq((Object)0));
        predicates.add(OnlineStatisticsRepoProc.statisticsDO.status.eq((Object)"1"));
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)statisticsDO).from((EntityPath)statisticsDO);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    private Predicate pagingWhere(StatisticsPagingParamVO query) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(OnlineStatisticsRepoProc.statisticsDO.deleteFlag.eq((Object)0));
        predicates.add(OnlineStatisticsRepoProc.statisticsDO.status.eq((Object)"1"));
        if (StrUtil.isNotBlank((CharSequence)query.getUid())) {
            predicates.add(OnlineStatisticsRepoProc.statisticsDO.uid.eq((Object)query.getUid()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getUsername())) {
            predicates.add(OnlineStatisticsRepoProc.statisticsDO.username.eq((Object)query.getUsername()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getNickname())) {
            String likeStr = SqlUtil.toSqlLikeString((String)query.getNickname());
            predicates.add(OnlineStatisticsRepoProc.statisticsDO.nickname.like(likeStr));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long statisticsCountBy(StatisticsPagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(OnlineStatisticsRepoProc.statisticsDO.id).from((EntityPath)statisticsDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<OnlineStatisticsDO> statisticsPageBy(StatisticsPagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)statisticsDO).from((EntityPath)statisticsDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, statisticsDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    public OnlineStatisticsRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

