package com.elitesland.cbpl.online.config;

import com.elitesland.cbpl.online.constant.OnlineConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.support.ThreadPoolBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.tool.websocket.config.WebSocketProperties.WX_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/11/21
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(OnlineProperties.class)
@ConditionalOnProperty(prefix = WX_CONFIG_PREFIX, name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class OnlineAutoConfiguration {

    /**
     * 共用线程池
     */
    @Bean(OnlineConstant.TP_ONLINE_POOL_NAME)
    public DtpExecutor onlineTp(OnlineProperties properties) {
        logger.info("[Online] online properties: {}", properties);
        return ThreadPoolBuilder.newBuilder()
                .threadPoolName(properties.getThreadPoolName())
                .threadFactory(properties.getThreadPrefix())
                .corePoolSize(properties.getCorePoolSize())
                .maximumPoolSize(properties.getMaximumPoolSize())
                .queueCapacity(properties.getQueueCapacity())
                .rejectedExecutionHandler(properties.getRejectPolicy())
                .eager()
                .buildDynamic();
    }
}
