package com.elitesland.cbpl.online.config;

import com.elitesland.cbpl.online.constant.OnlineConstant;
import lombok.Data;
import org.dromara.dynamictp.common.constant.DynamicTpConst;
import org.dromara.dynamictp.common.em.RejectedTypeEnum;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author eric.hao
 * @since 2024/11/24
 */
@Data
@ConfigurationProperties(prefix = OnlineProperties.ONLINE_CONFIG_PREFIX)
public class OnlineProperties {

    public static final String ONLINE_CONFIG_PREFIX = "cbpl.rosefinch.online";

    /**
     * 线程池名称
     */
    private String threadPoolName = OnlineConstant.TP_ONLINE_POOL_NAME;

    /**
     * 线程名称前缀
     */
    private String threadPrefix = OnlineConstant.TP_ONLINE_PREFIX;

    /**
     * 核心线程数，默认2
     */
    private int corePoolSize = 2;

    /**
     * 最大线程数，默认cpu核数
     */
    private int maximumPoolSize = DynamicTpConst.AVAILABLE_PROCESSORS;

    /**
     * 队列容量，默认1024
     */
    private int queueCapacity = 1024;

    /**
     * <li>拒绝策略：默认`AbortPolicy`</li>
     * <li>see: {@link RejectedTypeEnum}</li>
     */
    private String rejectPolicy = RejectedTypeEnum.ABORT_POLICY.getName();

    /**
     * Disruptor 的 RingBuffer 缓存大小【必须为2的N次方（能将求模运算转为位运算提高效率），否则将影响效率】
     */
    private int bufferSize = 1024 * 1024;
}
