package com.elitesland.cbpl.online.data.convert;

import com.elitesland.cbpl.online.data.entity.OnlineLogDO;
import com.elitesland.cbpl.online.data.entity.OnlineStatisticsDO;
import com.elitesland.cbpl.online.vo.resp.OnlineStatisticsVO;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

import java.util.List;

import static com.elitesland.cbpl.online.constant.OnlineConstant.*;

/**
 * @author eric.hao
 * @since 2024/11/25
 */
@Mapper(config = BaseMapperConfig.class)
public interface OnlineStatisticsConvert {

    OnlineStatisticsConvert INSTANCE = Mappers.getMapper(OnlineStatisticsConvert.class);

    /**
     * SaveParam => DO
     */
    List<OnlineStatisticsDO> saveParamToDO(List<OnlineLogDO> saveParam);

    /**
     * SaveParam => DO
     */
    @Mapping(target = "status", expression = "java(parseStatus(saveParam))")
    @Mapping(target = "lastActiveTime", source = "now")
    OnlineStatisticsDO saveParamToDO(OnlineLogDO saveParam);

    @Named("parseStatus")
    default String parseStatus(OnlineLogDO saveParam) {
        if (saveParam == null) {
            return null;
        }
        return saveParam.getType() == 1 ? SESSION_STATUS_ONLINE : SESSION_STATUS_OFFLINE;
    }

    /**
     * DO => RespVO
     */
    List<OnlineStatisticsVO> doToVO(List<OnlineStatisticsDO> onlineStatisticsDO);

    /**
     * DO => RespVO
     */
    OnlineStatisticsVO doToVO(OnlineStatisticsDO onlineStatisticsDO);
}
