package com.elitesland.cbpl.online.vo.resp;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 实时在线人数统计
 *
 * @author eric.hao
 * @since 2024/11/19
 */
@Data
public class OnlineStatisticsVO implements Serializable {

    private static final long serialVersionUID = -5369729843832199995L;

    /**
     * 唯一主键
     */
    private Long id;

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 登录账号
     */
    private String username;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 客户端IP
     */
    private String ip;

    /**
     * IP国家
     */
    private String country;

    /**
     * IP省份
     */
    private String province;

    /**
     * IP城市
     */
    private String city;

    /**
     * 最后活跃时间
     */
    private LocalDateTime lastActiveTime;
}
