package com.elitesland.cbpl.rosefinch.client.config;

import com.elitesland.cbpl.rosefinch.client.queue.consumer.ConsumerWrapper;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;
import com.elitesland.cbpl.rosefinch.queue.consumer.RocketmqQueueConsumer;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.rosefinch.client.config.RosefinchClientProperties.ROSEFINCH_CLIENT_PREFIX;

/**
 * @author eric.hao
 * @since 2024/10/09
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(RosefinchClientProperties.class)
@ConditionalOnProperty(prefix = ROSEFINCH_CLIENT_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
@RequiredArgsConstructor
public class RosefinchClientAutoConfiguration {

    /**
     * 消费者包装类
     */
    @Bean
    public <T extends TaskMessage<?>> ConsumerWrapper<T> consumerWrapper() {
        return new ConsumerWrapper<>();
    }

    /**
     * RocketMQ消费监听
     */
    @Bean
    public RocketmqQueueConsumer rosefinchQueueConsumer(ConsumerWrapper<TaskMessage<?>> consumerWrapper) {
        return new RocketmqQueueConsumer(consumerWrapper);
    }
}
