package com.elitesland.cbpl.rosefinch.queue.consumer;

import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;
import com.elitesland.cbpl.rosefinch.client.queue.consumer.ConsumerWrapper;
import lombok.RequiredArgsConstructor;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;

/**
 * @author eric.hao
 * @since 2024/10/08
 */
@RequiredArgsConstructor
@RocketMQMessageListener(topic = "${cbpl.rosefinch.client.app-code}", consumerGroup = "${cbpl.rosefinch.client.consumer-group}")
public class RocketmqQueueConsumer implements RocketMQListener<TaskMessage> {

    private final ConsumerWrapper consumerWrapper;

    @Override
    public void onMessage(TaskMessage payload) {
        consumerWrapper.consumer(payload);
    }
}