package com.elitesland.cbpl.rosefinch.queue.service;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskInfo;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;
import com.elitesland.cbpl.rosefinch.common.queue.ConsumerQueue;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.util.ReflectUtils;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import static com.elitesland.cbpl.rosefinch.client.constant.ScheduleClientConstant.SCHEDULE_CONSUMER_TAG;

/**
 * @author eric.hao
 * @since 2024/10/08
 */
@Slf4j
@Service
@UnicomTag(SCHEDULE_CONSUMER_TAG)
public class ScheduleConsumer implements ConsumerQueue {

    @Override
    public void run(TaskMessage payload) {
        TaskInfo taskInfo = payload.getHeader().getTaskInfo();
        Assert.notBlank(taskInfo.getClassName(), "[ROSEFINCH] class-name cannot be null");
        Assert.notBlank(taskInfo.getMethod(), "[ROSEFINCH] method cannot be null");
        // 1.优先使用业务参数；2.为null时 再使用配置中的固定参数
        String methodArgs = ObjectUtil.isNull(payload.getPayload()) ?
                taskInfo.getMethodArgs() : BeanUtils.toJsonOrEmpty(payload.getPayload());
        ReflectUtils.invokeMethod(taskInfo.getClassName(), taskInfo.getMethod(), methodArgs);
    }
}