package com.elitesland.cbpl.rosefinch.client.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.StrPool;
import com.elitesland.cbpl.rosefinch.client.constant.RosefinchType;
import com.elitesland.cbpl.rosefinch.client.queue.producer.dto.InstanceDTO;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;
import com.elitesland.cbpl.sns.bot.domain.BotRequest;
import com.elitesland.cbpl.sns.bot.util.BotSender;
import com.elitesland.cbpl.sns.bot.util.SnsBotUtil;

import java.time.LocalDateTime;

import static cn.hutool.core.date.DatePattern.NORM_DATETIME_MS_PATTERN;

/**
 * @author eric.hao
 * @since 2024/10/12
 */
public class InstanceBotUtil {

    /**
     * 在任务报错时，需要推送告警消息
     */
    public static <T extends TaskMessage<?>> void push(T payload, Exception e) {
        if (payload.warnFlag()) {
            BotSender.push(() -> {
                BotRequest request = new BotRequest();
                request.setExtObj(payload);
                return request;
            }, e);
        }
    }

    /**
     * 告警消息，是任务消息
     */
    public static boolean match(BotRequest request) {
        return request.getExtObj() instanceof TaskMessage;
    }

    /**
     * 告警消息，任务消息的默认模板
     */
    public static String getDefaultTemplate(BotRequest request) {
        if (InstanceBotUtil.match(request)) {
            TaskMessage<?> message = request.resolveExtObj(TaskMessage.class);
            InstanceDTO instanceDTO = message.getInstanceDTO();
            // 设置标题
            request.setSnsTitle(message.getTaskName() + "(" + message.getTaskCode() + ")");
            return "> 消息来源：任务中心(" + message.getTenantCode() + ")" + StrPool.LF +
                    "> MessageId：" + message.getMessageId() + StrPool.LF +
                    "> 请求时间：" + format(instanceDTO.getStartTime()) + StrPool.LF +
                    "> 执行时间：" + format(instanceDTO.getExecuteTime()) + StrPool.LF +
                    "> 结束时间：" + format(instanceDTO.getEndTime()) + StrPool.LF +
                    "> TraceID：" + instanceDTO.getTraceId() + StrPool.LF +
                    batchTypeMessage(message.getTaskType(), instanceDTO) +
                    "> 异常信息：" + SnsBotUtil.concat(request.getMessages());
        }
        return "";
    }

    /**
     * 时间格式化 yyyy-MM-dd HH:mm:ss.SSS
     */
    private static String format(LocalDateTime localDateTime) {
        return DateUtil.format(localDateTime, NORM_DATETIME_MS_PATTERN);
    }

    /**
     * 如果是批处理任务，增加处理结果
     */
    private static String batchTypeMessage(Integer taskType, InstanceDTO instanceDTO) {
        if (RosefinchType.BATCH.getCode().compareTo(taskType) == 0) {
            // 处理结果：成功/失败/总数 => 3/2/5
            return "> 处理结果：成功/失败/总数 => " +
                    instanceDTO.getSuccessCount() + StrPool.SLASH +
                    instanceDTO.getFailCount() + StrPool.SLASH +
                    instanceDTO.getTotalCount() + StrPool.LF;
        }
        return "";
    }
}
