/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.client.queue.producer.message;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import com.elitesland.cbpl.rosefinch.client.queue.producer.dto.InstanceDTO;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskHeader;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskInfo;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TaskMessage<T>
implements Serializable {
    private static final long serialVersionUID = -8551299374342363621L;
    private static final Logger log = LoggerFactory.getLogger(TaskMessage.class);
    private TaskHeader header;
    private T payload;

    public static <T> TaskMessage<T> withPayload(TaskInfo taskInfo) {
        return TaskMessage.withPayload(taskInfo, null);
    }

    public static <T> TaskMessage<T> withPayload(TaskInfo taskInfo, T payload) {
        TaskMessage<T> message = new TaskMessage<T>();
        TaskHeader header = new TaskHeader();
        header.setMessageId(IdUtil.fastSimpleUUID());
        header.setParentMdc(MDC.getCopyOfContextMap());
        header.setTenantCode(TenantSpiUtil.currentTenantCode());
        header.setTaskInfo(taskInfo);
        message.setHeader(header);
        message.setPayload(payload);
        return message;
    }

    public int size() {
        try {
            return CollUtil.size(this.payload);
        }
        catch (IllegalArgumentException e) {
            log.warn(e.getMessage());
            return 1;
        }
    }

    @JsonIgnore
    public String getMessageId() {
        return this.header.getMessageId();
    }

    @JsonIgnore
    public Map<String, String> getParentMdc() {
        return this.header.getParentMdc();
    }

    @JsonIgnore
    public String getTenantCode() {
        return this.header.getTenantCode();
    }

    @JsonIgnore
    public Long getTaskId() {
        return this.header.getTaskInfo().getTaskId();
    }

    @JsonIgnore
    public String getTaskCode() {
        return this.header.getTaskInfo().getTaskCode();
    }

    @JsonIgnore
    public String getTaskName() {
        return this.header.getTaskInfo().getTaskName();
    }

    @JsonIgnore
    public Integer getTaskType() {
        return this.header.getTaskInfo().getTaskType();
    }

    @JsonIgnore
    public InstanceDTO getInstanceDTO() {
        return this.header.getInstanceDTO();
    }

    public void setInstanceDTO(InstanceDTO instanceDTO) {
        this.header.setInstanceDTO(instanceDTO);
    }

    @JsonIgnore
    public boolean warnFlag() {
        Integer warnFlag = this.header.getTaskInfo().getWarnFlag();
        return warnFlag != null && warnFlag == 1;
    }

    public TaskHeader getHeader() {
        return this.header;
    }

    public T getPayload() {
        return this.payload;
    }

    public void setHeader(TaskHeader header) {
        this.header = header;
    }

    public void setPayload(T payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskMessage)) {
            return false;
        }
        TaskMessage other = (TaskMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TaskHeader this$header = this.getHeader();
        TaskHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        T this$payload = this.getPayload();
        T other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TaskHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        T $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        return result;
    }

    public String toString() {
        return "TaskMessage(header=" + this.getHeader() + ", payload=" + this.getPayload() + ")";
    }
}

