/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.client.util;

import cn.hutool.core.date.DateUtil;
import com.elitesland.cbpl.rosefinch.client.constant.RosefinchType;
import com.elitesland.cbpl.rosefinch.client.queue.producer.dto.InstanceDTO;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;
import com.elitesland.cbpl.sns.bot.domain.BotRequest;
import com.elitesland.cbpl.sns.bot.util.BotSender;
import com.elitesland.cbpl.sns.bot.util.SnsBotUtil;
import java.time.LocalDateTime;
import java.util.List;

public class InstanceBotUtil {
    public static <T extends TaskMessage<?>> void push(T payload, Exception e) {
        if (payload.warnFlag()) {
            BotSender.push(() -> {
                BotRequest request = new BotRequest();
                request.setExtObj((Object)payload);
                return request;
            }, (Exception)e);
        }
    }

    public static boolean match(BotRequest request) {
        return request.getExtObj() instanceof TaskMessage;
    }

    public static String getDefaultTemplate(BotRequest request) {
        if (InstanceBotUtil.match(request)) {
            TaskMessage message = (TaskMessage)request.resolveExtObj(TaskMessage.class);
            InstanceDTO instanceDTO = message.getInstanceDTO();
            request.setSnsTitle(message.getTaskName() + "(" + message.getTaskCode() + ")");
            return "> \u6d88\u606f\u6765\u6e90\uff1a\u4efb\u52a1\u4e2d\u5fc3(" + message.getTenantCode() + ")\n> MessageId\uff1a" + message.getMessageId() + "\n> \u8bf7\u6c42\u65f6\u95f4\uff1a" + InstanceBotUtil.format(instanceDTO.getStartTime()) + "\n> \u6267\u884c\u65f6\u95f4\uff1a" + InstanceBotUtil.format(instanceDTO.getExecuteTime()) + "\n> \u7ed3\u675f\u65f6\u95f4\uff1a" + InstanceBotUtil.format(instanceDTO.getEndTime()) + "\n> TraceID\uff1a" + instanceDTO.getTraceId() + "\n" + InstanceBotUtil.batchTypeMessage(message.getTaskType(), instanceDTO) + "> \u5f02\u5e38\u4fe1\u606f\uff1a" + SnsBotUtil.concat((List)request.getMessages());
        }
        return "";
    }

    private static String format(LocalDateTime localDateTime) {
        return DateUtil.format((LocalDateTime)localDateTime, (String)"yyyy-MM-dd HH:mm:ss.SSS");
    }

    private static String batchTypeMessage(Integer taskType, InstanceDTO instanceDTO) {
        if (RosefinchType.BATCH.getCode().compareTo(taskType) == 0) {
            return "> \u5904\u7406\u7ed3\u679c\uff1a\u6210\u529f/\u5931\u8d25/\u603b\u6570 => " + instanceDTO.getSuccessCount() + "/" + instanceDTO.getFailCount() + "/" + instanceDTO.getTotalCount() + "\n";
        }
        return "";
    }
}

