package com.elitesland.cbpl.rosefinch.client.queue.producer.message;

import com.elitesland.cbpl.rosefinch.client.queue.producer.dto.InstanceDTO;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2024/10/06
 */
@Data
public class TaskHeader implements Serializable {

    private static final long serialVersionUID = 2874882184390167066L;

    /**
     * 消息ID
     */
    private String messageId;

    /**
     * Saves the MDC value of the current thread
     */
    private Map<String, String> parentMdc;

    /**
     * 租户编码【可能为空】
     */
    private String tenantCode;

    /**
     * 任务配置
     */
    private TaskInfo taskInfo;

    /**
     * 任务实例
     */
    private InstanceDTO instanceDTO;
}
