/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.client.queue.consumer;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.rosefinch.client.constant.RosefinchType;
import com.elitesland.cbpl.rosefinch.client.queue.producer.dto.InstanceDTO;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;
import com.elitesland.cbpl.rosefinch.client.rpc.InstanceRpcService;
import com.elitesland.cbpl.rosefinch.client.spi.InstanceListener;
import com.elitesland.cbpl.rosefinch.client.util.InstanceBotUtil;
import com.elitesland.cbpl.rosefinch.common.constant.InstanceStatus;
import com.elitesland.cbpl.rosefinch.common.queue.ConsumerQueue;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.log.MDCUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import com.elitesland.cbpl.unicom.util.UnicomClient;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConsumerWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerWrapper.class);
    @Autowired(required=false)
    private InstanceListener instanceListener;
    @Resource
    private ConsumerQueue consumerQueue;
    @Resource
    private InstanceRpcService instanceRpcService;

    public void consumer(TaskMessage payload) {
        MDCUtil.setContextMap(payload.getParentMdc());
        String tenantCode = payload.getTenantCode();
        if (StrUtil.isBlank((CharSequence)tenantCode)) {
            this.executor(payload);
        } else {
            TenantSpiUtil.setCurrentTenant((String)tenantCode);
            this.executor(payload);
            TenantSpiUtil.resetCurrentTenant();
        }
    }

    private void executor(TaskMessage payload) {
        InstanceDTO instance = payload.getInstanceDTO();
        LogUtil.info((String)payload.getTaskCode(), null, (String)("[ROSEFINCH] \u4efb\u52a1(" + payload.getTaskCode() + ") \u5f00\u59cb\u6267\u884c\uff1a"), null, null);
        try {
            if (this.instanceListener != null) {
                this.instanceListener.start(instance);
            }
        }
        catch (Exception e) {
            logger.error("[ROSEFINCH] \u524d\u7f6e\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a", (Throwable)e);
        }
        Exception throwable = null;
        try {
            instance.setInstanceStatus(InstanceStatus.RUNNING.getCode());
            instance.setExecuteTime(LocalDateTime.now());
            this.instanceRpcService.update(instance);
            if (RosefinchType.REFLECT.getCode().compareTo(payload.getTaskType()) == 0) {
                UnicomClient.run(() -> this.consumerQueue.run(payload), (String)"__SCHEDULE");
            } else {
                UnicomClient.run(() -> this.consumerQueue.run(payload), (String)payload.getTaskCode());
            }
            instance.setInstanceStatus(InstanceStatus.COMPLETE.getCode());
        }
        catch (Exception e) {
            throwable = e;
            instance.setInstanceStatus(InstanceStatus.INTERRUPT.getCode());
            instance.setErrorMessage(ExceptionUtils.formatException((Throwable)e, (int)255));
            LogUtil.error((String)payload.getTaskCode(), null, (String)"[ROSEFINCH] \u6267\u884c\u5f02\u5e38\uff1a", null, (Throwable)e, null);
            InstanceBotUtil.push(payload, e);
        }
        instance.setEndTime(LocalDateTime.now());
        this.instanceRpcService.update(instance);
        LogUtil.info((String)payload.getTaskCode(), null, (String)"[ROSEFINCH] \u6267\u884c\u7ed3\u675f.", null, null);
        try {
            if (this.instanceListener != null) {
                this.instanceListener.whenComplete(instance, throwable);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)payload.getTaskCode(), null, (String)"[ROSEFINCH] \u540e\u7f6e\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff1a", null, (Throwable)e, null);
        }
    }
}

