/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.client.queue.producer.message;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import com.elitesland.cbpl.rosefinch.client.queue.producer.dto.InstanceDTO;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskHeader;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskInfo;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMessage
implements Serializable {
    private static final long serialVersionUID = -8551299374342363621L;
    private static final Logger log = LoggerFactory.getLogger(TaskMessage.class);
    private TaskHeader header;
    private Object payload;

    public static TaskMessage withPayload(TaskInfo taskInfo) {
        return TaskMessage.withPayload(taskInfo, null);
    }

    public static TaskMessage withPayload(TaskInfo taskInfo, Object payload) {
        TaskMessage message = new TaskMessage();
        TaskHeader header = new TaskHeader();
        header.setMessageId(IdUtil.fastSimpleUUID());
        header.setTenantCode(TenantSpiUtil.currentTenantCode());
        header.setTaskInfo(taskInfo);
        message.setHeader(header);
        message.setPayload(payload);
        return message;
    }

    public int size() {
        try {
            return CollUtil.size((Object)this.payload);
        }
        catch (IllegalArgumentException e) {
            log.warn(e.getMessage());
            return 1;
        }
    }

    @JsonIgnore
    public String getMessageId() {
        return this.header.getMessageId();
    }

    @JsonIgnore
    public Map<String, String> getParentMdc() {
        return this.header.getParentMdc();
    }

    public void setParentMdc(Map<String, String> parentMdc) {
        this.header.setParentMdc(parentMdc);
    }

    @JsonIgnore
    public String getTenantCode() {
        return this.header.getTenantCode();
    }

    @JsonIgnore
    public Long getTaskId() {
        return this.header.getTaskInfo().getTaskId();
    }

    @JsonIgnore
    public String getTaskCode() {
        return this.header.getTaskInfo().getTaskCode();
    }

    @JsonIgnore
    public String getTaskName() {
        return this.header.getTaskInfo().getTaskName();
    }

    @JsonIgnore
    public Integer getTaskType() {
        return this.header.getTaskInfo().getTaskType();
    }

    @JsonIgnore
    public InstanceDTO getInstanceDTO() {
        return this.header.getInstanceDTO();
    }

    public void setInstanceDTO(InstanceDTO instanceDTO) {
        this.header.setInstanceDTO(instanceDTO);
    }

    @JsonIgnore
    public boolean warnFlag() {
        Integer warnFlag = this.header.getTaskInfo().getWarnFlag();
        return warnFlag != null && warnFlag == 1;
    }

    public TaskHeader getHeader() {
        return this.header;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setHeader(TaskHeader header) {
        this.header = header;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskMessage)) {
            return false;
        }
        TaskMessage other = (TaskMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TaskHeader this$header = this.getHeader();
        TaskHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        Object this$payload = this.getPayload();
        Object other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TaskHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        Object $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        return result;
    }

    public String toString() {
        return "TaskMessage(header=" + this.getHeader() + ", payload=" + this.getPayload() + ")";
    }
}

