package com.elitesland.cbpl.rosefinch.client.queue.producer.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author eric.hao
 * @since 2025/01/20
 */
public class InstanceManager {

    /**
     * 待执行的队列集合
     */
    private static final Map<String, List<Long>> PENDING_ID_QUEUE = new ConcurrentHashMap<>();

    /**
     * 添加「待执行」的队列
     */
    public static void putPendingInstanceId(String topic, Long instanceId) {
        PENDING_ID_QUEUE.computeIfAbsent(topic, k -> new ArrayList<>()).add(instanceId);
    }

    /**
     * 读取「待执行」的队列
     */
    public static List<Long> getPendingInstanceIds(String topic) {
        return PENDING_ID_QUEUE.getOrDefault(topic, new ArrayList<>());
    }

    /**
     * 删除「待执行」的队列
     */
    public static boolean removePendingInstanceId(String topic, Long instanceId) {
        return getPendingInstanceIds(topic).remove(instanceId);
    }

    /**
     * 「待执行」的队列中，是否存在该实例
     */
    public static boolean pendingContains(String topic, Long instanceId) {
        return getPendingInstanceIds(topic).contains(instanceId);
    }

    /**
     * 手动中断的实例ID
     * <p>手动中断「就绪状态」的实例，会记录在该缓存中；在队列执行到时跳过</p>
     */
    private static final Map<String, List<Long>> STOPPED_ID_QUEUE = new ConcurrentHashMap<>();

    /**
     * 添加手动中断的任务实例
     */
    public static void putStopInstanceId(String topic, Long instanceId) {
        STOPPED_ID_QUEUE.computeIfAbsent(topic, k -> new ArrayList<>()).add(instanceId);
    }

    /**
     * 读取手动中断的任务实例
     */
    public static List<Long> getStopInstanceIds(String topic) {
        return STOPPED_ID_QUEUE.getOrDefault(topic, new ArrayList<>());
    }

    /**
     * 删除手动中断的任务实例
     */
    public static boolean removeStopInstanceId(String topic, Long instanceId) {
        return getStopInstanceIds(topic).remove(instanceId);
    }

    /**
     * 「手动中断」的队列中，是否存在该实例
     */
    public static boolean stopContains(String topic, Long instanceId) {
        return getStopInstanceIds(topic).contains(instanceId);
    }
}
