/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.client.queue.producer.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InstanceManager {
    private static final Map<String, List<Long>> PENDING_ID_QUEUE = new ConcurrentHashMap<String, List<Long>>();
    private static final Map<String, List<Long>> STOPPED_ID_QUEUE = new ConcurrentHashMap<String, List<Long>>();

    public static void putPendingInstanceId(String topic, Long instanceId) {
        PENDING_ID_QUEUE.computeIfAbsent(topic, k -> new ArrayList()).add(instanceId);
    }

    public static List<Long> getPendingInstanceIds(String topic) {
        return PENDING_ID_QUEUE.getOrDefault(topic, new ArrayList());
    }

    public static boolean removePendingInstanceId(String topic, Long instanceId) {
        return InstanceManager.getPendingInstanceIds(topic).remove(instanceId);
    }

    public static boolean pendingContains(String topic, Long instanceId) {
        return InstanceManager.getPendingInstanceIds(topic).contains(instanceId);
    }

    public static void putStopInstanceId(String topic, Long instanceId) {
        STOPPED_ID_QUEUE.computeIfAbsent(topic, k -> new ArrayList()).add(instanceId);
    }

    public static List<Long> getStopInstanceIds(String topic) {
        return STOPPED_ID_QUEUE.getOrDefault(topic, new ArrayList());
    }

    public static boolean removeStopInstanceId(String topic, Long instanceId) {
        return InstanceManager.getStopInstanceIds(topic).remove(instanceId);
    }

    public static boolean stopContains(String topic, Long instanceId) {
        return InstanceManager.getStopInstanceIds(topic).contains(instanceId);
    }
}

